<?php
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Widgets Tour
 *
 * @author  physcode
 * @version 2.0.0
 */
class TravelPhysWidget {
	public static function init() {
		add_action( 'widgets_init', array( __CLASS__, 'tb_load_widget_phys' ) );

	}

	public static function tb_load_widget_phys() {
		register_widget( 'tb_search_widget_phys' );
	}
}

TravelPhysWidget::init();

class tb_search_widget_phys extends WP_Widget {
	public function __construct() {
		$widget_ops = array(
			'classname'   => 'tb_search_widget',
			'description' => __( 'Tour Search', 'travel-booking' ),
		);
		parent::__construct( 'tb_search_widget_phys', 'Tour Search', $widget_ops );
	}

	public function form( $instance ) {
		$defaults            = array(
			'hide_tour_name'      => 'show',
			'hide_tour_type'      => 'show',
			'show_tour_code'      => 'hide',
			'show_filter_ratting' => 'hide',
			'show_filter_price'   => 'hide',
		);
		$instance            = wp_parse_args( (array) $instance, $defaults );
		$hide_tour_name      = $instance['hide_tour_name'];
		$hide_tour_type      = $instance['hide_tour_type'];
		$show_tour_code      = $instance['show_tour_code'];
		$show_filter_ratting = $instance['show_filter_ratting'];
		$show_filter_price   = $instance['show_filter_price'];
		?>
		<p>
			<label><?php echo esc_html__( 'Tour Name', 'travel-booking' ); ?></label>
			<select name="<?php echo ent2ncr( $this->get_field_name( 'hide_tour_name' ) ); ?>" class="widefat">
				<option value="hide" <?php selected( $hide_tour_name, 'hide' ) ?>><?php esc_html_e( 'Hide', 'travel-booking' ) ?></option>
				<option value="show" <?php selected( $hide_tour_name, 'show' ) ?>><?php esc_html_e( 'Show', 'travel-booking' ) ?></option>
			</select>
		</p>
		<p>
			<label><?php echo esc_html__( 'Tour Type', 'travel-booking' ); ?></label>
			<select name="<?php echo ent2ncr( $this->get_field_name( 'hide_tour_type' ) ); ?>" class="widefat">
				<option value="hide" <?php selected( $hide_tour_type, 'hide' ) ?>><?php esc_html_e( 'Hide', 'travel-booking' ) ?></option>
				<option value="show" <?php selected( $hide_tour_type, 'show' ) ?>><?php esc_html_e( 'Show', 'travel-booking' ) ?></option>
			</select>
		</p>
		<p>
			<label><?php echo esc_html__( 'Show Tour Code', 'travel-booking' ); ?></label>
			<select name="<?php echo ent2ncr( $this->get_field_name( 'show_tour_code' ) ); ?>" class="widefat">
				<option value="hide" <?php selected( $show_tour_code, 'hide' ) ?>><?php esc_html_e( 'Hide', 'travel-booking' ) ?></option>
				<option value="show" <?php selected( $show_tour_code, 'show' ) ?>><?php esc_html_e( 'Show', 'travel-booking' ) ?></option>
			</select>
		</p>
		<p>
			<label><?php echo esc_html__( 'Show Filter Ratting', 'travel-booking' ); ?></label>
			<select name="<?php echo ent2ncr( $this->get_field_name( 'show_filter_ratting' ) ); ?>" class="widefat">
				<option value="hide" <?php selected( $show_filter_ratting, 'hide' ) ?>><?php esc_html_e( 'Hide', 'travel-booking' ) ?></option>
				<option value="show" <?php selected( $show_filter_ratting, 'show' ) ?>><?php esc_html_e( 'Show', 'travel-booking' ) ?></option>
			</select>
		</p>
		<p>
			<label><?php echo esc_html__( 'Show Filter Price', 'travel-booking' ); ?></label>
			<select name="<?php echo ent2ncr( $this->get_field_name( 'show_filter_price' ) ); ?>" class="widefat">
				<option value="hide" <?php selected( $show_filter_price, 'hide' ) ?>><?php esc_html_e( 'Hide', 'travel-booking' ) ?></option>
				<option value="show" <?php selected( $show_filter_price, 'show' ) ?>><?php esc_html_e( 'Show', 'travel-booking' ) ?></option>
			</select>
		</p>
	<?php }

	public function widget( $args, $instance ) {
		extract( $args );
		$hide_tour_name      = isset( $instance['hide_tour_name'] ) ? $instance['hide_tour_name'] : 'show';
		$hide_tour_type      = isset( $instance['hide_tour_type'] ) ? $instance['hide_tour_type'] : 'show';
		$show_tour_code      = isset( $instance['show_tour_code'] ) ? $instance['show_tour_code'] : 'hide';
		$show_filter_ratting = isset( $instance['show_filter_ratting'] ) ? $instance['show_filter_ratting'] : 'hide';
		$show_filter_price   = isset( $instance['show_filter_price'] ) ? $instance['show_filter_price'] : 'hide';

		$tour_tax_param = get_query_var( 'tourtax' );
		?>
		<div class="search_tour">
			<div class="form-block block-after-indent">
				<h3 class="form-block_title"><?php _e( 'Search Tour', 'travel-booking' ) ?></h3>
				<div class="form-block__description"><?php _e( 'Find your dream tour today!', 'travel-booking' ) ?></div>
				<form method="get" action="<?php echo home_url() ?>">
					<input type="hidden" name="tour_search" value="1">
					<?php
					if ( $hide_tour_name != 'hide' ) {
						echo '<div class="form-field-input">
								<input type="text" placeholder="' . __( 'Search Tour', 'travel-booking' ) . '" value="" name="name_tour">
							</div>';
					}
					if ( $show_tour_code == 'show' ) {
						$tour_code = '';
						if ( isset( $_GET['tour_code'] ) ) {
							$tour_code = $_GET['tour_code'];
						}
						?>
						<div class="form-field-input">
							<input type="text" placeholder="<?php _e( 'Tour Code', 'travel-booking' ); ?>" value="<?php echo $tour_code ?>" name="tour_code">
						</div>
					<?php }
					if($hide_tour_type == 'show') {
						?>
						<div class="form-field-select">
							<select name="tourtax[tour_phys]">
								<option value="0"><?php _e( 'Tour Type', 'travel-booking' ) ?></option>
								<?php
								$taxonomy   = 'tour_phys'; // taxonomy slug
								$tour_terms = get_terms( $taxonomy );
								if ( $tour_terms ) {
									foreach ( $tour_terms as $term ) {
										if ( is_array( $tour_tax_param ) && $term->slug == $tour_tax_param[$taxonomy] ) {
											echo '<option value="' . $term->slug . '" selected="selected">' . $term->name . '</option>';
										} else {
											echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
										}
									}
								}
								?>
							</select>
						</div>

						<?php
					}
					if ( get_option( 'tour_search_by_attributes' ) ) {
						$option_attribute_to_search = get_option( 'tour_search_by_attributes' );
						foreach ( $option_attribute_to_search as $attribute_to_search ) {
							$tax_attribute      = get_taxonomy( $attribute_to_search );
							$terms_of_attribute = get_terms( $attribute_to_search );
							if ( ( !empty( $terms_of_attribute ) && !is_wp_error( $terms_of_attribute ) ) && count( $terms_of_attribute ) > 0 ) {
								echo '<div class="form-field-select"><select name="tourtax[' . $attribute_to_search . ']">';
								echo '<option value="0">' . esc_html__( $tax_attribute->labels->singular_name, 'travel-booking' ) . '</option>';
								foreach ( $terms_of_attribute as $term ) {
									if ( is_array( $tour_tax_param ) && $term->slug == $tour_tax_param[$attribute_to_search] ) {
										echo '<option value="' . $term->slug . '" selected="selected">' . $term->name . '</option>';
									} else {
										echo '<option value="' . $term->slug . '">' . $term->name . '</option>';
									}
								}
								echo '</select></div>';
							}
						}
					}
					?>

					<?php
					if ( $show_filter_ratting == 'show' ) {
						wp_enqueue_style( 'barrating' );
						wp_enqueue_script( 'barrating-js' );
						wp_enqueue_script( 'widget-search-js' );
						/*** Filter by star ***/
						$show_filter_tour_rating = apply_filters( 'phys_tour_filter_rating', true );

						if ( $show_filter_tour_rating ) {
							$tour_rating_arr = array( 1, 2, 3, 4, 5 );

							$tour_rating = '';
							if ( isset( $_GET['tour_rating'] ) ) {
								$tour_rating = $_GET['tour_rating'];
							}
							?>
							<div class="tour-rating">
								<span><?php _e( 'Rating', 'travel-booking' ) ?></span>
								<select name="tour_rating" id="tour_rating">
									<option value=""></option>
									<?php
									foreach ( $tour_rating_arr as $rating ) {
										$tour_rating_selected = '';

										if ( $tour_rating == $rating ) {
											$tour_rating_selected = 'selected';
										} else {
											$tour_rating_selected = '';
										}

										echo '<option value="' . $rating . '" ' . $tour_rating_selected . '>' . $rating . '</option>';
									}
									?>
								</select>
							</div>
						<?php }
					} ?>
					<?php
					if ( $show_filter_price == 'show' ) {
						/*** Filter price tour ***/
						wp_enqueue_style( 'slider-range' );
						wp_enqueue_script( 'slider-range-js' );
						wp_enqueue_script( 'widget-search-js' );
						$show_filter_price_tour = apply_filters( 'phys_tour_filter_price', true );

						if ( $show_filter_price_tour ) {
							global $wpdb;

							$tax_query  = array();
							$meta_query = array();

							$tax_query[] = array(
								'taxonomy' => 'product_type',
								'terms'    => array( 'tour_phys' ),
								'field'    => 'slug',
								'operator' => 'IN',
							);

							$meta_query = new WP_Meta_Query( $meta_query );
							$tax_query  = new WP_Tax_Query( $tax_query );

							$meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
							$tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

							$sql = "SELECT min( FLOOR( price_meta.meta_value ) ) as min_price, max( CEILING( price_meta.meta_value ) ) as max_price FROM {$wpdb->posts} ";
							$sql .= " LEFT JOIN {$wpdb->postmeta} as price_meta ON {$wpdb->posts}.ID = price_meta.post_id " . $tax_query_sql['join'] . $meta_query_sql['join'];
							$sql .= " 	WHERE {$wpdb->posts}.post_type IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_post_type', array( 'product' ) ) ) ) . "')
							AND {$wpdb->posts}.post_status = 'publish'
							AND price_meta.meta_key IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_meta_keys', array( '_price' ) ) ) ) . "')
							AND price_meta.meta_value > 0 ";
							$sql .= $tax_query_sql['where'] . $meta_query_sql['where'];

							$price_range = $wpdb->get_row( $sql );
							?>
							<div class="form-field-input" style="text-align: left">
								<p>
									<span><?php _e( 'Price range', 'travel-booking' ) ?></span>
									<?php
									$start_price = $price_range->min_price;
									$end_price   = $price_range->max_price;

									if ( isset( $_GET['tour_min_price'] ) && isset( $_GET['tour_max_price'] ) ) {
										$start_price = $_GET['tour_min_price'];
										$end_price   = $_GET['tour_max_price'];
									}

									echo sprintf( '%s - %s', TravelPhysUtility::tour_format_price( $start_price, 'tour-min-price' ), TravelPhysUtility::tour_format_price( $end_price, 'tour-max-price' ) );
									?>
								</p>
								<div id="tour-price-range"></div>
								<input type="hidden" name="tour_min_price" value="<?php echo $start_price ?>">
								<input type="hidden" name="tour_max_price" value="<?php echo $end_price ?>">
							</div>
							<input type="hidden" name="tour_start_price_fitler" value="<?php echo $price_range->min_price ?>">
							<input type="hidden" name="tour_end_price_filter" value="<?php echo $price_range->max_price ?>">
							<?php
						}
					}
					?>

					<input type="hidden" name="lang" value="<?php echo isset( $_GET['lang'] ) ? $_GET['lang'] : '' ?>">
					<button type="submit"><?php _e( 'Find Tours', 'travel-booking' ) ?></button>
				</form>


			</div>
		</div>
		<?php
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
 		$instance['hide_tour_name']      = sanitize_text_field( $new_instance['hide_tour_name'] );
		$instance['hide_tour_type']      = sanitize_text_field( $new_instance['hide_tour_type'] );
		$instance['show_tour_code']      = sanitize_text_field( $new_instance['show_tour_code'] );
		$instance['show_filter_ratting'] = sanitize_text_field( $new_instance['show_filter_ratting'] );
		$instance['show_filter_price']   = sanitize_text_field( $new_instance['show_filter_price'] );

		return $instance;
	}
}